class Manager extends Impiegato
{
    private String nomeSegretaria;  
    
    public Manager(String nome, String matricola, double salario, int anniDiServizio, String nomeSegretaria){
    	super(nome, matricola, salario, anniDiServizio);
    	this.nomeSegretaria = nomeSegretaria;
    }
    
    //metodo in overriding
    //incrementa il salario, aggiungendo 1% alla percentuale di incremento
    public void incrementaSalario(double percentuale)
    {
    	double salario = getSalario();
    	salario = salario * (1 + (percentuale + 1) / 100);
        setSalario(salario);
    }
    
    public String getNomeSegretaria()
    {
        return nomeSegretaria;
    }
    
    public void setNomeSegretaria(String nome)
    {
        nomeSegretaria = nome;
    }
    
    //metodo in overriding
    public String getInfo()
    {
        return super.getInfo() + " " + nomeSegretaria;
    }
}
