import java.util.Scanner;

public class Eccezioni
{
    public static void main(String[] args) 
    {
        Eccezioni eccez = new Eccezioni();
        String str = "";
        
        //lettura del numero da tastiera
        System.out.println("Inserisci il numero: ");
        str = eccez.leggiRigaDaTastiera();
        
        //esempio1: conversione senza alcuna gestione dell'errore
        int n1 = 0;//eccez.strToNum_noGestione(str);
        System.out.println("Numero convertito1: " + n1);
        
        //esempio2: conversione tramite metodo che gestisce l'errore
        int n2 = eccez.strToNum_tryCatch(str);
        System.out.println("Numero convertito2: " + n2);
        
        //esempio3: conversione tramite metodo che rilancia l'errore
        try {
            int n3 = eccez.strToNum_throws(str);
            System.out.println("Numero convertito3: " + n3);
        } 
        //nel main, si gestisce l'eccezione (non viene propagata, cioè rilanciata ad altri metodi)
        catch(Exception e) {
            e.printStackTrace();
        }
        
        //finally contiene codice che viene eseguito in ogni caso, anche se il try lancia un eccezione
        //se è presente un return, il codice del finally viene eseguito subito prima del return 
        finally {
            System.out.println("(Eccezione gestita)");
        }
        
        //esempio4: conversione tramite metodo che rilancia l'errore tramite una eccezione personalizzata
        try {
            int n4 = eccez.strToNum_throwsPersonalizzato(str);
            System.out.println("Numero convertito4: " + n4);
        } 
        //nel main, si gestisce l'eccezione (non viene propagata, cioè rilanciata ad altri metodi)
        catch(EccezioneClasse e) {
            e.stampaErrore();
            //e.printStackTrace();
        }
        finally {
            System.out.println("(Eccezione gestita)");
        }
    }

    
    //metodo che legge una riga da tastiera
    private String leggiRigaDaTastiera() 
    {
        Scanner s = new Scanner(System.in);
        String riga = s.nextLine();
        
        return riga;
    }

    
    //metodo di conversione da String -> int, senza gestione dell'errore
    private int strToNum_noGestione(String s) {
        int num = Integer.parseInt(s);
        return num;
    }
    
    
    //metodo di conversione da String -> int, con gestione dell'errore tramite costrutto try-catch
    private int strToNum_tryCatch(String s) {
        int num = -1;
        try {
            num = Integer.parseInt(s);
        } catch (NumberFormatException e) {
            System.out.println(" > C'è stato un errore durante la conversione del numero");
            //e.printStackTrace();
        }
        return num;
    }
    
    
    //metodo di conversione da String -> int, con gestione dell'errore tramite costrutto try-catch e classe Eccezione personalizzata
    //il costrutto throws indica che il metodo puo' rilanciare l'eccezione al metodo chiamante
    private int strToNum_throws(String s) throws NumberFormatException
    {
        int num = -1;
        try {
            num = Integer.parseInt(s);
        } catch (NumberFormatException exc) {
            //il costrutto throw permette di rilanciare l'eccezione al metodo chiamante
            //throw termina l'esecuzione del try-catch
            throw exc;
        }
        return num;
    }
    
    
    //metodo di conversione da String -> int, con gestione dell'errore tramite costrutto try-catch e classe Eccezione personalizzata
    //il costrutto throws indica che il metodo puo' rilanciare l'eccezione al metodo chiamante
    private int strToNum_throwsPersonalizzato(String s) throws EccezioneClasse
    {
        int num = -1;
        try {
            num = Integer.parseInt(s);
        } catch (NumberFormatException e) {
            //il costrutto throw permette di lanciare una nuova eccezione personalizzata
            //throw termina l'esecuzione del try-catch
            throw new EccezioneClasse(s);
        }
        return num;
    }

}
