import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;


public class UsoDeiFiles 
{
    //metodo che restituisce true se un certo file esiste, false atrimenti1
    public boolean esisteFile(String perc)
    {
        File f = new File(perc);
        return f.exists();
    }
    
    //metodo che scrive in un dato file una data stringa
    public boolean scritturaBufferedWriter(String filePath, String stringa) 
    {
        //si controlla che il file in cui scrivere esista
        if(esisteFile(filePath))
        {
            try {
                //apertura del file in scrittura, specificamndo 'false' come secondo parametro
                BufferedWriter output = new BufferedWriter(new FileWriter(filePath, false));
                output.write(stringa);
                //se vogliamo inserire un 'a capo', si usa il metodo .newLine(), es:
                //output.newLine();
                //una volta scritto il file, deve essere chiuso
                output.close();
                return true;
            } catch (IOException e) {
                System.out.println("Errore scrittura Buffered Writer");
                e.printStackTrace();
            }
        } 
        else
            System.out.println("Impossibile scrivere: file inesistente");
        return false;
    }
    
    //metodo che scrive in un dato file una data stringa in modalita' append, cioè scrive partendo dalla fine del file
    public boolean appendBufferedWriter(String nomeFile, String stringaDaScrivere) 
    {
        if( esisteFile(nomeFile))
        {
            try {
                //apertura del file in append mode, specificamndo 'true' come secondo parametro
                BufferedWriter output = new BufferedWriter(new FileWriter(nomeFile, true));
                output.append(stringaDaScrivere);
                //una volta scritto il file, deve essere chiuso
                output.close();
                return true;
            } catch (IOException e) {
                System.out.println("Errore append Buffered Writer");
                e.printStackTrace();
            }
        }
        else
            System.out.println("Impossibile scrivere: file inesistente");
        return false;
    }
    
    
    //metodo che legge l'intero file e lo restituisce sotto forma di 
    public ArrayList<String> leggiInteroFile(String nomeFile) 
    {
        try {
            ArrayList<String> arr = new ArrayList<String>();
            BufferedReader input = new BufferedReader(new FileReader(nomeFile));
            String str;
            while( (str = input.readLine()) != null) { 
                arr.add(str);
            }
            input.close();
            return arr;
        } catch (IOException e) {
            System.out.println("Errore lettura Buffered Reader");
            e.printStackTrace();
            return null;
        }
//      return "";
    }
    
    //metodo che crea un file.
    //se il file esiste, si controlla il valore booleano sovrascrivi per decidere se sovrascrivere o meno il file
    public File creaFile(String nomeFile, boolean sovrascrivi)
    {
        //si controlla se il file esiste già
        if(esisteFile(nomeFile)){     //se esiste, si controlla se e' richiesto di sovrascrivere il file
            if(sovrascrivi)     //se è richiesto, si cancella il file, altrimenti il metodo termina
                rimuoviFile(nomeFile);
            else
                return null;
        }
        //si crea il nuovo file
        try {
            File file = new File(nomeFile);
            file.createNewFile();
            return file;
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
    
    //overloading del metodo che non sovrascrive il file
    public File creaFile(String nomeFile)
    {
        return creaFile(nomeFile, false);
    }
    
    //metodo che apre e restituisce un file se esiste, restituisce null altrimenti
    public File apriFile(String nomeFile)
    {
        File file = null;
        if(esisteFile(nomeFile))
            file = new File(nomeFile);
        return file;
    }
    
    //metodo che rimuove un file
    public boolean rimuoviFile(String nomeFile)
    {
        try {
            File file = new File(nomeFile);
            //cancella un file; se il file è una cartella, deve essere vuota per poter essere cancellata
            file.delete();
            return true;
        } catch (SecurityException e) {
            e.printStackTrace();
        }
        return false;
    }
    
}
