import java.io.*;
import java.io.IOException;

public class ContaRigheFile
{   
    //metodo che restituisce true se un certo file esiste, false atrimenti
    public boolean esisteFile(String perc)
    {
        File f = new File(perc);
        return f.exists();
    }
    
    //metodo che conta e restituisce il numero di righe in un file
    public int contaRighe(String file)
    {
        int cont = 0;   //contatore che tiene conto del numero di righe lette
        try {
            BufferedReader input = new BufferedReader(new FileReader(file));
            String str;
            //si leggono tutte le righe, e per ogni riga si incrementa il contatore
            while( (str = input.readLine()) != null) {
                cont ++;
            }
            input.close();
            return cont;
        } catch (IOException e) {
            System.out.println("Errore lettura Buffered Reader");
            e.printStackTrace();
            return -1;
        }
    }
    
    
    //metodo che conta il numero di caratteri in un file di testo
    public int contaCaratteri(String file)
    {
        int cont = 0;   //contatore che tiene conto del numero di righe lette
        try {
            //si apre il file in lettura
            BufferedReader input = new BufferedReader(new FileReader(file));
            String str;
            //si leggono tutte le righe, e per ogni riga si contano il numero di caratteri letti
            while( (str = input.readLine()) != null) {
                cont += str.length();
            }
            input.close();
            return cont;
        } catch (IOException e) {
            System.out.println("Errore lettura Buffered Reader");
            e.printStackTrace();
            return -1;
        }
    }
    
    //metodo che crea un file e lo restituisce se non esiste, altrimenti restituisce null
    public File creaFile(String nomeFile)
    {
        if(!esisteFile(nomeFile) ) {
            //si crea il file
            try {
                File file = new File(nomeFile);
                file.createNewFile();
                return file;
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        //nel caso non sia possibile creare il file 
        //(es: viene lanciata una exception), si restituisce null
        return null;
    }
    
    //metodo che rimuove un file, se esiste e restituisce true; altrimenti restituisce false
    public boolean rimuoviFile(String nomeFile)
    {
        try {
            if(esisteFile(nomeFile)) {
                File file = new File(nomeFile);
                //si cancella il file; se il file è una cartella, deve essere vuota per poter essere cancellata
                file.delete();
                return true;
            }
        } catch (SecurityException e) {
            e.printStackTrace();
        }
        return false;
    }
    
    //metodo che scrive, in un dato file, una data stringa
    public boolean scritturaBufferedWriter(String filePath, String stringa) 
    {
        //si controlla che il file in cui scrivere esista
        if(esisteFile(filePath))
        {
            try {
                //apertura del file in scrittura
                BufferedWriter output = new BufferedWriter(new FileWriter(filePath, true));
                output.write(stringa);
                //se vogliamo inserire un 'a capo', si usa il metodo .newLine(), es:
                //output.newLine();
                //una volta scritto il file, deve essere chiuso
                output.close();
                return true;
            } catch (IOException e) {
                System.out.println("Errore scrittura Buffered Writer");
                e.printStackTrace();
            }
        } 
        else
            System.out.println("Impossibile scrivere: file inesistente");
        return false;
    }

}
