
/** *
 *MountainBike è una classe che ha lo scopo di gestire una bicicletta
 */
public class MountainBike 
{
    /**
      * Attributo di istanza che tiene traccia della velocità della bicicletta
      * @see MountainBike#accelera
      * @see MountainBike#decelera
      */
    private int velocita;
    /**
      * Attributo di istanza che tiene traccia della marcia inserita
      * @see MountainBike#setMarcia
      * @see MountainBike#getMarcia
      */
    private int marcia;
    /**
      * Attributo di istanza che tiene traccia del fatto che la bicicletta
      * abbia o meno gli ammortizzatori
      * @see MountainBike#setAmmortizzatori
      * @see MountainBike#hasAmmortizzatori
      */
    private boolean hasAmmortizzatori;
    /**
      * Attributo di istanza che si riferisce alla velocità massima raggiungibile dalla bountain bike
      * @see MountainBike#accelera
      */
    private int maxVelocita;
    /**
      * Attributo di istanza che si riferisce alla massima marcia inseribile dalla bountain bike
      * Notare il riferimento incrociato al metodo mioMetodo...
      * @see MountainBike#setMarcia
      */
    private int maxMarcia;
    
    //..costruttori
    /**
      * Costruttore che inizializza la mountain bike a velocità 0, marcia 0 e senza ammortizzatori
      * @param     maxVelocita  Velocità massima della mountain bike
      * @param     maxMarcia  Marcia massima della mountain bike
      */
    public MountainBike(int maxVelocita, int maxMarce) {
        this.velocita = 0;
        this.marcia = 0;
        this.hasAmmortizzatori = false;
        this.maxVelocita = maxVelocita;
        this.maxMarcia = maxMarcia;
    }
    
    /**
      * Costruttore che inizializza la mountain bike a velocità 0 e marcia 0.
      * @param     hasAmmortizzatori  Se la mountain bike è in possesso di ammortizzatori o meno
      * @param     maxVelocita  Velocità massima della mountain bike
      * @param     maxMarcia  Marcia massima della mountain bike
      */
    public MountainBike(boolean hasAmmortizzatori, int maxVelocita, int maxMarce) {
        this.hasAmmortizzatori = hasAmmortizzatori;
        this.maxVelocita = maxVelocita;
        this.maxMarcia = maxMarcia;
    }
    

    //metodi
    /**
      * Imposta la presenza o meno di ammortizzatori per la mountain bike
      * @param     hasAmmortizzatori  Se la mountain bike è in possesso di ammortizzatori o meno
      */
    public void setAmmortizzatori(boolean hasAmmortizzatori) {
        this.hasAmmortizzatori = hasAmmortizzatori;
    }

    /**
      * Visualizza la presenza o meno di ammortizzatori per la mountain bike
      * @return    Se la mountain bike è in possesso di ammortizzatori o meno
      */
    public boolean hasAmmortizzatori() {
        return hasAmmortizzatori;
    }
    
    /**
      * Aumenta la velocità della mountain bike, controllando che la velocità risultante non superi la velocità massima
      * @param     AumentoVelocita  di qunti Km/h sarà aumentata la velocità della mountain bike
      */
    public void accelera(int aumentoVelocita) {
        velocita += aumentoVelocita;
        if(velocita > maxVelocita)
            velocita = maxVelocita;
    }
    
    /**
      * Diminuisce la velocità della mountain bike, controllando che la velocità risultante non sia minore di 0
      * @param     diminuzioneVelocita  Di qunti Km/h sarà diminuita la velocità della mountain bike
      */
    public void decelera(int diminuzioneVelocita) {
        velocita -= diminuzioneVelocita;
        if(velocita < 0)
            velocita = 0;
    }
    
    /**
      * Imposta la marcia inserita dalla bicicletta controllando che questa sia maggiore di 0 e minore o uguale alla msssima marcia inseribile
      * @param     marcia  Numero della marcia da inserire
      */
    public void setMarcia(int marcia) {
        //se la marcia no è valida, non viene impostata
        if(marcia > 0 && marcia <= maxMarcia)
            this.marcia = marcia;
    }
    
    /**
      * Restituisce la marcia attualemnte inserita dalla mountain bike
      * @return    La marcia attualemente inserita
      */
    public int getMarcia() {
        return marcia;
    }

    /**
      * Restituisce la descrizione della mountain bike (velocità, marcia, ammortizzatori, velocità massima, marcia massima)
      * @return    La descrizione della mountain bike
      */
    public String getDescrizione() {
        return "velocita': " + velocita + ", marcia: " + marcia + ", ha hasAmmortizzatori: " + hasAmmortizzatori + ", velocita' max: " + maxVelocita + ", marcia max: " + maxMarcia;
    }
}