import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class Main {
    
    public static void main(String[] args) {
        //array non tipizzato
        //quando si eseguono delle operazioni su un array non tipizzato 
        //il compilatore mostra un warning
        //ArrayList arrNonTipizzato = new ArrayList();
        //arrNonTipizzato.add(new Persona("Luca", 26));
        //arrNonTipizzato.add(new Persona("Marco",10));
        //arrNonTipizzato.add(new Persona("Giovanni",34));
        
        //la riga seguente comporta un errore a runtime (esecuzione)
        //il compilatore non riconosce che stiamo passando un dato non corretto
        //arrNonTipizzato.add(19);

        //array tipizzato. E' sempre consigliabile usare un array specificando il tipo
        ArrayList<Persona> arrTipizzato = new ArrayList<Persona>();
        arrTipizzato.add(new Persona("Giorgio", 12));
        arrTipizzato.add(new Persona("Paola", 17));
        arrTipizzato.add(new Persona("Maurizio", 70));
        arrTipizzato.add(new Persona("Giulia", 55));
        //la riga seguente restituisce un errore di compilazione, poichè il compilatore riconosce che
        //il metodo prende in input un int, mentre dovrebbe prendere in input un ggetto Persona
        //arrTipizzato.add(19);
        
        
        Main main = new Main();
        int risultatoSommaFor = main.stampaArrayListFor(arrTipizzato);
        System.out.println("stampaArrayListFor: " + risultatoSommaFor);

        int risultatoSommaForEach = main.stampaArrayListForEach(arrTipizzato);
        System.out.println("stampaArrayListForEach: " + risultatoSommaForEach);

        main.rimuoviMinorenniIterator(arrTipizzato);
        
        int risultatoSommaIterator = main.stampaArrayListIterator(arrTipizzato);
        System.out.println("stampaArrayListIterator: " + risultatoSommaIterator);
    }

    
    //stampa di un ArrayList tramite il costrutto for
    public int stampaArrayListFor(ArrayList<Persona> array) {
        int somma = 0;
        //for standard: specifichiamo il valore iniziale, la condizione di uscita, l'incremento
        for(int i = 0; i < array.size(); i++) {
            System.out.println(array.get(i).toString());
        }
        return somma;
    }

    //stampa di un ArrayList tramite il costrutto foreach
    public int stampaArrayListForEach(ArrayList<Persona> array) {
        int somma = 0;
        //foreach: permette di scorrere ogni elemento di un array
        //Non e' necessario l'uso di indici come nel for
        //'Persona persona : array' permette di selezionare, ad ogni iterazione, un elemento persona contenuto in array
        //al termine del ciclo for, tutti gli elementi in array saranno stati selezionati una e una sola volta
        for(Persona persona : array)
            System.out.println(persona.toString());
        return somma;
    }

    //stampa di un ArrayList tramite un iteratore
    public int stampaArrayListIterator(ArrayList<Persona> array) {
        int somma = 0;
        //iterator: oggetto che gestisce lo scorrimento dell'array e la cancellazione degli elementi
        //Non e' necessario l'uso di indici come nel for
        Iterator<Persona> iterator = array.iterator();
        //hasNext restituisce true se ci sono altri elementi da iterare, false altrimenti
        while(iterator.hasNext()){
            //next restituisce il prossimo elemento dell'iterazione
            Persona persona = iterator.next();
            System.out.println(persona.toString());
        }
        return somma;
    }
    
    
    
    //metodo che rimuove dall'array le persone con eta' < 18
    public void rimuoviMinorenniFor(ArrayList<Persona> array) {
        //si scorre tutto l'array con il for
        for(int i = 0; i < array.size(); i++) {
            Persona persona = array.get(i);
            //quando si trova una persona con eta < 18, lo si rimuove dall'array
            if(persona.getEta() < 18) {
                //quando rimuoviamo un elemento, dobbiamo considerare che tutti gli elementi successivi 
                //sono "spostati" a sinistra. usaimo i-- per accedere ancora l'elemento in posizione i
                //(adesso e' l'elemento che prima del remove stava a destra)
                array.remove(i);
                //i--;
            }
        }
    }
    
    //rimozione dall'array delle persone con eta' < 18 usando l'iterator
    public void rimuoviMinorenniIterator(ArrayList<Persona> array) {
        //si scorre tutto l'array con l'iterator
        Iterator<Persona> iterator = array.iterator();
        while(iterator.hasNext()) {
            //quando si trova una persona con eta < 18, l'iterator rimuove 
            //quell' elemento, e gestisce quale sarà il prossimo elemento da iterare
            Persona persona = iterator.next();
            if(persona.getEta() < 18)
                iterator.remove();
        }
    }
}
