import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class Main {

    /*
     * ArrayList vs Vector:
     * Entrambi servono per contenere una lista ordinata e dinamica di oggetti
     * 
     * ArrayList: durante il resize aumenta la sua dimensione del 50%
     * Vector: durante il resize aumenta la sua dimensione del 100%. 
     *         Permette anche di specificare il numero di posizioni da incrementare durante il resize
     */
    
    public static void main(String[] args) {
        Main main = new Main();
        Vector<Persona> personeVector = new Vector<Persona>();
        personeVector.add(new Persona("Luca",26));
        personeVector.add(new Persona("Marco",10));
        personeVector.add(new Persona("Giovanni",34));  
        
        main.stampaVectorFor(personeVector);
        main.stampaVectorForeach(personeVector);
        main.stampaVectorEnumeration(personeVector);
    }

    
    public void stampaVectorFor(Vector<Persona> vector) {
        //for standard: specifichiamo il valore iniziale, la condizione di uscita, l'incremento
        for(int i = 0; i < vector.size(); i++) {
            System.out.println(vector.get(i).toString());
        }
    }

    public void stampaVectorForeach(Vector<Persona> vector) {
        //foreach: permette di scorrere ogni elemento di un array
        //Non e' necessario l'uso di indici come nel for 
        for(Persona persona : vector)
            System.out.println(persona.toString());
    }
    
    public void stampaVectorEnumeration(Vector<Persona> vector) {
        //Enumeration: equivalente all'iterator per gli ArrayList
        //gestisce lo scorrimento dell'array e la cancellazione degli elementi 
        //Non e' necessario l'uso di indici come nel for 
        Enumeration<Persona> enumeration = vector.elements();
        
        while (enumeration.hasMoreElements()){
            Persona persona = enumeration.nextElement();
            System.out.println(enumeration.nextElement().toString());
        }
    }

}
