import java.util.regex.Pattern;
import java.util.regex.Matcher;

class TestRegEx {
  
    private Pattern pattern;
    private Matcher matcher;
    
    //verifica che la stringa in input contenga un qualsiasi carattere
    public boolean verificaAll(String str) {
        pattern = Pattern.compile(".");
        matcher = pattern.matcher(str);
        if(matcher.matches()) return true;
        else return false;
    }
    
    //verifica che la stringa in input sia "Hello World"
    public boolean verificaHelloWorld(String str){
        pattern = Pattern.compile("Hello World");
        matcher = pattern.matcher(str);
        if(matcher.matches()) return true;
        else return false;
    }
      
    //verifica che la stringa in input contenga "a" oppure "b" oppure "c"
    public boolean verificaAbc(String str){
        pattern = Pattern.compile("[abc]");
        matcher = pattern.matcher(str);
        if(matcher.matches()) return true;
        else return false;
    }
    
    //verifica che la stringa in input non contenga "a", "b", "c"
    public boolean verificaNotAbc(String str){
        pattern = Pattern.compile("[^abc]");
        matcher = pattern.matcher(str);
        if(matcher.matches()) return true;
        else return false;
    }
    
    //verifica che la stringa in input contenga tre caratteri qualsiasi tra "a" oppure "b" oppure "c"
    public boolean verificaAbc3(String str){
        pattern = Pattern.compile("[abc]{3}");
        matcher = pattern.matcher(str);
        if(matcher.matches()) return true;
        else return false;
    }
    
    //verifica che la stringa in input contenga un carattere tra "a", "b", "c", ...., "u", "v", "z"
    public boolean verificaAz(String str){
        pattern = Pattern.compile("[a-z]");
        matcher = pattern.matcher(str);
        if(matcher.matches()) return true;
        else return false;
    }
    
    //verifica che la stringa in input contenga un carattere tra "A", "B", "C", ...., "U", "V", "Z"
    public boolean verificaAZ(String str){
        pattern = Pattern.compile("[A-Z]");
        matcher = pattern.matcher(str);
        if(matcher.matches()) return true;
        else return false;
    }
    
    //verifica che la stringa in input contenga un numero tra "0", "1", "2", ...., "7", "8", "9"
    public boolean verifica09(String str){
        pattern = Pattern.compile("[0-9]");
        matcher = pattern.matcher(str);
        if(matcher.matches()) return true;
        else return false;
    }
    
    //verifica che la stringa in input contenga uno o più caratteri tra "a", "b", "c", ...., "u", "v", "z"
    public boolean verificaAzPlus(String str){
        pattern = Pattern.compile("[a-z]+");
        matcher = pattern.matcher(str);
        if(matcher.matches()) return true;
        else return false;
    }
    
    //verifica che la stringa in input contenga zero o più caratteri tra "a", "b", "c", ...., "u", "v", "z"
    public boolean verificaAzStar(String str){
        pattern = Pattern.compile("[a-z]*");
        matcher = pattern.matcher(str);
        if(matcher.matches()) return true;
        else return false;
    }
    
    //verifica che la stringa in input contenga zero o un carattere tra "a", "b", "c", ...., "u", "v", "z"
    public boolean verificaAzQuestion(String str){
        pattern = Pattern.compile("[a-z]?");
        matcher = pattern.matcher(str);
        if(matcher.matches()) return true;
        else return false;
    }
    
    //verifica che la stringa in input contenga due o più caratteri tra "a", "b", "c", ...., "u", "v", "z"
    public boolean verificaAz2OrMore(String str){
        pattern = Pattern.compile("[a-z]{2,}");
        matcher = pattern.matcher(str);
        if(matcher.matches()) return true;
        else return false;
    }
    
    //verifica che la stringa in input contenga da zero a tre caratteri tra "a", "b", "c", ...., "u", "v", "z"
    public boolean verificaAzMax3(String str){
        pattern = Pattern.compile("[a-z]{0,3}");
        matcher = pattern.matcher(str);
        if(matcher.matches()) return true;
        else return false;
    }
    
    //verifica che la stringa in input contenga un carattere tra ("a", "b", "c", ...., "u", "v", "z") intersecato ("d", "e", "f")
    //quindi, verifica che la stringa in input contenga un carattere tra "d" o "e" o "f"
    public boolean verificaDef(String str){
        pattern = Pattern.compile("[a-z&&[def]]");
        matcher = pattern.matcher(str);
        if(matcher.matches()) return true;
        else return false;
    }
    
    //verifica che la stringa in input contenga un carattere tra ("a", "b", "c", ...., "u", "v", "z") intersecato (non "b", "c")
    //quindi, verifica che la stringa in input contenga un qualsiasi carattere minuscolo tranne "b" e "c"
    public boolean verificaAzNotBc(String str){
        pattern = Pattern.compile("[a-z&&[^bc]]");
        matcher = pattern.matcher(str);
        if(matcher.matches()) return true;
        else return false;
    }
    
    //verifica che la stringa in input contenga un carattere tra ("a", "b", "c", ...., "u", "v", "z") intersecato (non "m", "n", "o", "p")
    //quindi, verifica che la stringa in input contenga un qualsiasi carattere minuscolo tranne "m" e "n" e "o" e "p"
    public boolean verificaAzNotMp(String str){
        pattern = Pattern.compile("[a-z&&[^m-p]]");
        matcher = pattern.matcher(str);
        if(matcher.matches()) return true;
        else return false;
    }
    
    //verifica che la stringa in input contenga un carattere tra ("a", "b", "c", ...., "u", "v", "z") oppure 1
    public boolean verificaAzOr1(String str){
        pattern = Pattern.compile("[a-z]|1");
        matcher = pattern.matcher(str);
        if(matcher.matches()) return true;
        else return false;
    }  
    
    //verifica che la stringa in input contenga uno o più caratteri tra ("a", "b", "c", ...., "u", "v", "z") oppure 1
    public boolean verificaAzOr1Plus(String str){
        pattern = Pattern.compile("[[a-z]|1]+");
        matcher = pattern.matcher(str);
        if(matcher.matches()) return true;
        else return false;
    } 
    
    //verifica che la stringa in input contenga (uno o più caratteri tra ("a", "b", "c", ...., "u", "v", "z") oppure 1) e successivamente "3"
    public boolean verificaAzOr1PlusAfter3(String str){
        pattern = Pattern.compile("[[a-z]|1]+3");
        matcher = pattern.matcher(str);
        if(matcher.matches()) return true;
        else return false;
    } 
    
    //verifica che la stringa in input contenga un indirizzo e-mail valido
    public boolean verificaEmail(String str){
        pattern = Pattern.compile("[a-zA-z0-9._%-]+@[a-zA-z0-9._%-]+\\.[a-zA-Z]{2,4}");
        matcher = pattern.matcher(str);
        if(matcher.matches()) return true;
        else return false;
    }
    
    //verifica che la stringa in input sia una data nella forma dd/mm/aaaa
    public boolean verificaData(String str){
        pattern = Pattern.compile("(0[1-9]|[12][0-9]|3[01])/(0[1-9]|1[012])/[0-9]{4}");
        matcher = pattern.matcher(str);
        if(matcher.matches()) return true;
        else return false;
    }
    
    //verifica che la stringa in input contenga un codice fiscale valido
    public boolean verificaCodiceFiscale(String str){
        pattern = Pattern.compile("[a-zA-Z]{6}[0-9]{2}[a-zA-Z](0[1-9]|[12][0-9]|3[01])[a-zA-Z][0-9]{3}[a-zA-Z]");
        matcher = pattern.matcher(str);
        if(matcher.matches()) return true;
        else return false;
    }
  
}