
class SeletionSort
{
    public static void main(String[] args)
    {
        SeletionSort ms = new SeletionSort();
        int[] arr = {3, 65, 12, 86, 99, 36, 42, 6, 61, 34};
        System.out.print("Array iniziale:");
        ms.stampaArray(arr);
        
        ms.selectionRicorsivo(arr);
        
        //stampa del vettore
        System.out.print("Array finale  :");
        ms.stampaArray(arr);
    }
    
    //metodo che effettua il selection sort ricorsivo
    public void selectionRicorsivo(int[] arr)
    {
        selectionRicorsivo(arr, 0, arr.length -1);
    }
    
    //metodo ricorsivo che effettua il selection sort su una porzione dell'array, definitaa da inizio e fine
    private void selectionRicorsivo(int[] arr, int inizio, int fine)
    {
        //se stiamo considerando un solo elemento, allora l'array è stato completamente ordinato
        if(inizio == fine)
            return;

        //permette di memorizzare la posizione dell'elemento più piccolo
        int pos = inizio;
        //questa iterazione permette di trovare l'elemento più piccolo tra gli indici di inizio e fine
        for(int i = inizio; i <= fine; i++)
        {
            if(arr[i] < arr[pos])
                pos = i;
        }
        //se è stato trovato un elemento più piccolo rispetto a quello iniziale,
        //si effettua dello scambio
        if(pos != inizio) {
            int scambio = arr[inizio];
            arr[inizio] = arr[pos];
            arr[pos] = scambio;
        }
        //si applica il selection sort a tutto l'array tranne il primo elemento (che è stato appena ordinato)
        selectionRicorsivo(arr, inizio +1, fine);
    }
    
    
    public void stampaArray(int[] arr, int inizio, int fine)
    {
        System.out.print("[" + inizio + ", " + fine + "] = {");
        if(arr.length > 0) {
            for(int i = inizio; i < fine; i++)
                System.out.print(arr[i] + ", ");
            System.out.print(arr[fine]);
        }
        System.out.println("}");
    }
    
    public void stampaArray(int[] arr)
    {
        stampaArray(arr, 0, arr.length-1);
    }
}
