
class MergeSort
{   
    //effettua il mergeSort di un array
    //restituisce un nuovo array ordinato contenete gli elementi dell'array in input
    public void mergeSort(int[] arr)
    {
        mergeSort(arr, 0, arr.length-1);
    }

    //metodo ricorsivo del merge sort
    private void mergeSort(int[] a, int left, int right) 
    {
        //la ricorsione si applica finchè c'è un array la cui dimensione è > 1
        if (left < right) 
        {
            //si divide l'array in due sotto-array
            int center = (left + right) / 2;
            //si richiama il mergeSort ricorsivamente sui due sotto-array
            mergeSort(a, left, center);
            mergeSort(a, center +1, right);
            //si applica il merge ai due sotto-array (che ora sono ordinati)
            merge(a, left, center, right);
        }
        //else array di un elemento quindi già ordinato
    }

    /*
     * effettua il merge tra due array; si suppone che i due array siano ordinati
     * L'algoritmo si basa sul fatto che i due sotto-array siano contigui (uno subito dopo l'altro)
     * Opera selezionando di volta in volta gli elementi dei due array, e aggiungendo quello
     * più piccolo nell'array ordinato
     * Si usano degli indici per selezionare i sotto array contenuti all'interno dell'array principale
     * Opera selezionando di volta in volta gli elementi dei due array, e aggiungendo quello
     * più piccolo nell'array ordinato
     *
     * left indica la posizione del primo elemento del primo sotto-array
     * center indica la posizione dell'ultimo elemento del primo sotto-array
     * center+1 indica la posizione del primo elemento del secondo sotto-array (che infatti inizia subito dopo il primo sotto-array)
     * right indica la posizione dell'ultimo elemento del secondo sotto-array
     */
    private void merge(int a[], int left, int center, int right)
    {
        int i;  //indice che scorre il primo sotto-array
        int j;  //indice che scorre il secondo sotto-array
        int k;  //indice che scorre l'array ordinato creato dal merge
        
        //si crea un nuovo array che conterrà gli elementi ordinati
        int[] b = new int[a.length];
        
        System.out.println("merge di: [" + left + ", " + right + "]");
        
        i = left;           //si posiziona l'indice i all'inizio del primo sotto-array
        j = center + 1;     //si posiziona l'indice j all'inizio del secondo sotto-array
        k = left;           //si posiziona l'indice k all'inizio dell'array ordinato

        //finchè ci sono elementi sia nel primo sotto-array che nel secondo si continua con il merge
        while (i <= center && j <= right) {
            //ad ogni iterazione, si controlla quale degli elementi correnti dei due sotto-array sia il minore 
        	//lo si aggiunge all'array ordinato, e si incrementa il rispettivo indice 
            if (a[i] <= a[j]) {
                b[k] = a[i];
                i = i + 1;
            }
            else {
                b[k] = a[j];
                j = j + 1;
            }
            //in ogni caso, si incrementa l'indice dell'array ordinato
            k ++;
        }
        
        //se rimangono elementi del primo sotto-array
        while (i <= center) {
            b[k] = a[i];
            i = i + 1;
            k = k + 1;
        }

        //se rimangono elementi del secondo sotto-array
        while (j <= right) {
            b[k] = a[j];
            j = j + 1;
            k = k + 1;
        }

        //si copia l'array ordinato nell'array originale
        for (k = left; k <= right; k++) {
            a[k] = b[k];
        }
        
        System.out.print("iterazione " + i + ": ");
        stampaArray(a);
    }
    
    public void stampaArray(int[] arr, int inizio, int fine)
    {
        System.out.print("[" + inizio + ", " + fine + "] = {");
        if(arr.length > 0) {
            for(int i = inizio; i < fine; i++)
                System.out.print(arr[i] + ", ");
            System.out.print(arr[fine]);
        }
        System.out.println("}");
    }
    
    public void stampaArray(int[] arr)
    {
        stampaArray(arr, 0, arr.length-1);
    }
}
