public class MergeSort2 
{
    //effettua il mergeSort di un array
    //restituisce un nuovo array ordinato contenete gli elementi dell'array in input
    public int[] mergeSort(int[] arr) 
    {
        //la ricorsione si applica finchè c'è un array la cui dimensione è > 1
        if(arr.length > 1) 
        {
            //si divide l'array in due array;
            int centro = (arr.length) / 2;
            //si richiama il mergeSort ricorsivamente sui due array
            //-1 per scomporre gli array di due elementi in 2 array di un elemento
            int[] arr1 = mergeSort(subArray(arr, 0, centro -1));
            int[] arr2 = mergeSort(subArray(arr, centro, arr.length-1));
            //si applica il merge ai due array (che ora sono ordinati), ottenendo l'array iniziale ordinato
            return merge(arr1, arr2);
        }
        else    //array di un elemento, quindi già ordinato 
            return arr;
    }
    
    /*
     * effettua il merge tra due array; si suppone che i due array siano ordinati
     * Opera selezionando di volta in volta gli elementi dei due array, e aggiungendo quello
     * più piccolo nell'array ordinato
     */
    private int[] merge(int[] arr1, int[] arr2)
    {
        //si crea un nuovo array che conterrà gli elementi ordinati
        int[] arr3 = new int[arr1.length + arr2.length];
        
        int i1 = 0; //indice che scorre arr1
        int i2 = 0; //indice che scorre arr2
        int i3 = 0; //indice che scorre arr3
        
        //finchè ci sono elementi sia nel primo array che nel secondo si continua con il merge
        while (i1 < arr1.length && i2 < arr2.length) {
            //ad ogni iterazione, si controlla quale degli elementi correnti dei due array sia il minore 
            //lo si aggiunge all'array ordinato, e si incrementa il rispettivo indice 
            if (arr1[i1] <= arr2[i2]) {
                arr3[i3] = arr1[i1];
                i1++;
            }
            else {
                arr3[i3] = arr2[i2];
                i2++;
            }
            //in ogni caso, si incrementa l'indice dell'array ordinato
            i3++;
        }
        
        //se rimangono elementi del primo array
        while (i1 < arr1.length) {
            arr3[i3] = arr1[i1];
            i1++;
            i3++;
        }

        //se rimangono elementi del secondo array
        while (i2 < arr2.length) {
            arr3[i3] = arr2[i2];
            i2++;
            i3++;
        }
        
        return arr3;
    }

    //metodo che copia un porzione di un array e lo restituisce in un nuovo array
    private int[] subArray(int[] arr, int inizio, int fine) 
    {
        //controlli di validità degli indici
        if(inizio < 0 || fine >= arr.length || inizio > fine) 
            return null;
        //si crea un nuovo array e si copiano tutti gli elementi compresi tra gli indici di inizio e fine
        int[] subArr = new int[fine - inizio +1];
        for(int i = 0; i <= fine - inizio; i ++)
            subArr[i] = arr[inizio + i];
        
        return subArr;
    }
    
    public void stampaArray(int[] arr, int inizio, int fine)
    {
        System.out.print("[" + inizio + ", " + fine + "] = {");
        if(arr.length > 0) {
            for(int i = inizio; i < fine; i++)
                System.out.print(arr[i] + ", ");
            System.out.print(arr[fine]);
        }
        System.out.println("}");
    }
    
    public void stampaArray(int[] arr)
    {
        stampaArray(arr, 0, arr.length-1);
    }
}
