public class Fattoriale {

    public static void main(String[] args) 
    {
        int n = 2;
        Fattoriale fatt = new Fattoriale();
        //si richiama il metodo fattoriale iterativo
        System.out.println("fattoriale di " + n + ": " + fatt.fattorialeRicorsivo(n));
        //si richiama il metodo fattoriale ricorsivo
        System.out.println("fattoriale di " + n + ": " + fatt.fattorialeIterativo(n));
    }
    
    
    /*
     * Il fattoriale iterativo di un numero n si calcola moltiplicando tutti i numeri interi da 1 a n
     */
    public int fattorialeIterativo(int n) 
    {
        //se il numero e' <= 1 si restituisce 1
        if(n <= 1)
            return 1;
        int fatt = 1;
        //ciclo che viene eseguito finche' il numero deve essere moltiplicato per il fattoriale precedente
        //il ciclo termina quando in numero da moltiplicare e' 1
        while(n >= 2) {
            //si moltiplica il fattoriale precedente con il numero considerato
            fatt *= n;
            //si diminuisce il numero di 1
            n--;
        }
        return fatt;
    }

    
    /*
     * Il fattoriale ricorsivo e' definito come:
     * fatt(n) = n * fatt(n - 1), oppure fatt(n) = 1 se n = 1
     */
    public int fattorialeRicorsivo(int n) {
        if(n <= 1)
            return 1;
        else
            return n * fattorialeRicorsivo(n - 1);
    }
}
