import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Constructor;

public class Main
{
    public static void main(String[] args){
        
        //si recupera l'oggetto Classe di tipo Persona
        Class<Persona> classPersona = Persona.class;
        
        try{
            //si recupera l'attributo nome della classe Persona
            Field fieldNome = classPersona.getField("nome");
            System.out.println(fieldNome.getName());
            
            //si recupera l'attributo eta della classe Persona
            Field fieldEta = classPersona.getField("eta");
            System.out.println(fieldEta.getName());
        }
        //eccezione scatenata dal metodo getField
        catch(NoSuchFieldException e){
            System.out.println("Uno o più attributi non sono stati trovati");
        }
        
        try{
            //si recupera il metodo aggiungiEta (che non ha nessun parametro in input) della classe Persona
            Method methodAggiungiEta = classPersona.getMethod("aggiungiEta", new Class[] {});
            System.out.println(methodAggiungiEta.getName());
        }
        //eccezione scatenata dal metodo getMethod
        catch(NoSuchMethodException e){
            System.out.println("Uno o più metodi non sono stati trovati");
        }
        
        try{
            //si recupera il costruttore 
            //(che ha il primo parametro in input di tipo String e il secondo di tipo int ) 
            //della classe Persona
            Constructor costructor = classPersona.getConstructor(new Class[]{String.class, int.class});
            System.out.println(costructor.getName());
        }
        catch(NoSuchMethodException e){
            System.out.println("Uno o più costruttori non sono stati trovati");
        }
        
    }
}
