import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;

public class Main
{
    
    public static void main(String[] args)
    {
        ArrayList<Persona> persone = new ArrayList<Persona>();
        
        /*
         * Per rappresentare una data, si puo' usare la classe LocalDate.
         * LocalDate non mette a disposizione un costruttore, quindi non si puo' instanziare un oggetto tramite il solito new LocalDate(...)
         * Invece, fornisce un metodo statico LocalDate.of che prende in input tre parametri:
         *  - un intero che rappresenta un anno
         *  - un intero che rappresenta un mese; in alternativa e' possibile fornire un oggetto Month utilizzando una sua costante
         *  - un intero che rappresenta un giorno del mese
         */
        
        persone.add(new Persona("Nome1", "Cognome1", LocalDate.of(1987, Month.NOVEMBER, 12)));  //utilizzo della classe Month
        persone.add(new Persona("Nome2", "Cognome2", LocalDate.of(2000, 5, 10)));               //utilizzo di un intero
        //utilizzo di un intero ricavato dal metodo getValue, chiamato su un oggetto della classe Month
        persone.add(new Persona("Nome3", "Cognome3", LocalDate.of(1995, Month.MARCH.getValue(), 21)));  
        persone.add(new Persona("Nome4", "Cognome4", LocalDate.of(1980, 11, 30)));
        persone.add(new Persona("Nome5", "Cognome5", LocalDate.of(2010, 7, 8)));
        
        System.out.println("Lista persone: ");
        stampaPersone(persone);
        System.out.println("\nLista persone minorenni: ");
        stampaPersoneMinorenni(persone);
    }
    
    //metodo che stampa una lista
    public static void stampaPersone(ArrayList<Persona> arrPer)
    {
        for(Persona p : arrPer)
            System.out.println(p.toString());
    }
    
    //metodo che stampa solo le persone minorenni
    public static void stampaPersoneMinorenni(ArrayList<Persona> arrPer)
    {
        for(Persona p : arrPer)
        {
            if(p.getAnni() < 18)
                System.out.println(p.toString());
        }
    }
}
