import java.time.LocalDate;
import java.time.Month;
import java.time.Period;

public class Persona
{
    private String nome;
    private String cognome;
    private LocalDate dataNascita;
    
    /*
     * costruttore
     */
    public Persona(String nome, String cognome, LocalDate dataNascita)
    {
        this.nome = nome;
        this.cognome = cognome;
        this.dataNascita = dataNascita;
    }
    
    //get
    public String getNome() {
        return nome;
    }
    
    public String getCognome() {
        return cognome;
    }
    
    public LocalDate getDataNascita() {
        return dataNascita;
    }
    
    /*
     * Restituisce l'eta della persona, in un oggetto Period, che contiene informazioni
     * come anni, mesi e giorni trascorsi
     */
    public Period getEta()
    {
        /*
         * per effettuare il calcolo dell'eta' in maniera opportuna, non si deve memorizzare un intero che indica la data
         * piuttosto, di deve memorizzare la data di nascita e calcolare l'eta' tramite un metodo
         */
        //si prende la data odierna
        LocalDate oggi = LocalDate.now();
        /*
         * si calcola il periodo tra la data odierna e la data di nascita
         * il metodo until restituisce un oggetto Period che memorizza i giorni, 
         * i mesi e gli anni di di differenza tra 2 LocalDate
         */
        Period eta = dataNascita.until(oggi);
        //in alternativa, si può usare il metodo statico Period.between:
        //Period eta = Period.between(dataNascita, oggi);
        return eta;
    }
    
    /*
     * Restituisce gli anni
     */
    public int getAnni() 
    {
        //e' possibile chiamare il metodo getYears da un oggetto LocalDate 
        //per ricavare solo il valore degli anni da quell'oggetto Localdate
        return getEta().getYears();
    }
    
    /*
     * Stampa l'eta su console
     */
    public void stampaEta()
    {
        Period eta = getEta();
        //e' possibile richiamare i metodi getYears, getMonths e getDays per ricavare rispettivamente 
        //il valore degli anni, dei mesi e fei giorni da un oggetto Localdate
        System.out.println("eta': " + eta.getYears() + " anni, " + eta.getMonths() + " mesi, " + eta.getDays() + " giorni");
    }
    
    /*
     * Restituisce una stringa contenente gli attributi di questa persona
     */
    public String toString()
    {
        return nome + " " + cognome
                + " " + dataNascita + " (" + getAnni() + " anni)";
    }
}
