<?php
// Functions required by index.php
function doAction($action) {
	// Load functions
	require('actions_funs.php');
	if (!is_numeric($action)) {
		// Error
		doError("Error: Bad Action");
		return;
	}
	switch($action) {
		case 0: // Default Action: Show Home Page
			doDefault();
			break;
		case 1: // Login -- Require credentials
			doLogin();
			break;
		case 2: // Sign Up Page
			doSignUpPage();
			break;
		case 3: // Sign Up -- Require form with mandatory/optional fields
			doSignUp();
			break;
		case 4: // Show / Modify Profile Page
			doProfilePage();
			break;
		case 5: // Reply Show / Modify Profile
			doProfile();
			break;
      	case 6: // Logout
      		doLogout();
      		break;
      	// TODO Aggiungere altre funzionalità del blog!
      	default: // Unknown action
      		doError("Error: Bad Action Number");
    }
}
?>