<?php
function doError($msg){
  require('page_left.php'); 
  echo "<div class=\"content\"><p class=\"errormsg\">$msg\n\n</p><hr />";
  echo "</div>";
}

function test_input($data) {
  $data = trim($data);
  $data = stripslashes($data);
  $data = htmlspecialchars($data);
  return $data;
}

function doDefault() {
	  require('page_left.php'); 
	  echo "<div class=\"content\">";
	  echo "<p>TODO!</p>";
	  echo "</div>";
}


function doLogin() {
	  require('page_left.php'); 
	  echo "<div class=\"content\">";
	  echo "<p>TODO!</p>";
	  echo "</div>";
}

function doInsertUser(){
	// TODO Insert in database e controllo
	// Se va tutto bene inizializzo le variabili di sessione
	if (!isset($_SESSION['userName'])) {
		$_SESSION['userName'] = test_input($_POST["userName"]);
		$_SESSION['name'] = test_input($_POST["name"]);	
	}  
	require('page_left.php');  
	echo "<div class=\"content\">";
	echo "<p>Insert User Done!</p>";
	echo "</div>";
	// TODO Generare la parte sinistra e il content nel caso ci sia un problema 
	// con l'inserimento
}

function doSignUpPage() {
	 // Controllo se nessuno è loggato
	 if (isset($_SESSION['userName'])) {
	 	 doError("Please, log out user " . $_SESSION['userName'] . " first.");
	 	 return;
	 }
	 // Inizializzo tutte le variabili che mi servono
	 $userName = $userNameErr = $password = $passwordErr =
	 $repeatedPassword = $repeatedPasswordErr = $name = 
	 $nameErr = $email = $emailErr = $website = $websiteErr =
	 $description = $gender = $genderErr = "";
	 // Controllo se la richiesta arriva da link o da form
	 if ($_SERVER["REQUEST_METHOD"] == "POST") { 	  
	 	 // L'utente ha mandato dei dati da form via post	  
	 	 // Controllo tutti i campi e assegno gli errori
	 	 
	 	 // UserName
	 	 if (empty($_POST["userName"])) {
	 	 	 $userNameErr = "UserName is required";
	  	 } else {
	  	 	 $userName = test_input($_POST["userName"]);
	  	 	 // check if name only contains letters 
	  	 	 if (!preg_match("/^[a-zA-Z]*$/",$userName)) {
	  	 	 	 $userNameErr = "Only letters allowed";
	  	 	 }
	  	 }		
	  	 // Password
	  	 if (empty($_POST["password"])) {
	  	 	 $passwordErr = "Password is required";
	  	 } else {
	  	 	 $password = test_input($_POST["password"]);
	  	 	 // check if password only contains letters or numbers
	  	 	 if (!preg_match("/^[a-zA-Z0-9]*$/",$password)) {
	  	 	 	 $passwordErr = "Only letters or numbers allowed";
	  	 	 }
	  	 }
	  	 // Ripetizione della Password
      	 if (empty($_POST["repeatedPassword"])) {
      	 	 $repeatedPasswordErr = "Repeated Password is required";
      	 } else {
      	 	 $repeatedPassword = test_input($_POST["repeatedPassword"]);
      	 	 // check if password only contains letters or numbers
      	 	 if (!preg_match("/^[a-zA-Z0-9]*$/",$repeatedPassword)) {
      	 	 	 $repeatedPasswordErr = "Only letters or numbers allowed";
      	 	 }
      	 	 if ($password !== $repeatedPassword) {
      	 	 	 $repeatedPasswordErr = "Repeated Password is not equal to Password";
      	 	 }
      	 }
      	 // Nome
      	 if (empty($_POST["name"])) {
      	 	 $nameErr = "Name is required";
      	 } else {
      	 	 $name = test_input($_POST["name"]);
      	 	 // check if name only contains letters and whitespace
      	 	 if (!preg_match("/^[a-zA-Z ]*$/",$name)) {
      	 	 	 $nameErr = "Only letters and white space allowed";
      	 	 }
      	 }
      	 // Email
      	 if (empty($_POST["email"])) {
      	 	 $emailErr = "Email is required";
      	 } else {
      	 	 $email = test_input($_POST["email"]);
      	 	 // check if e-mail address is well-formed
      	 	 if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
      	 	 	 $emailErr = "Invalid email format";
      	 	 }
      	 }
      	 // Website
      	 if (empty($_POST["website"])) {
      	 	 $website = "";
      	 } else {
      	 	 $website = test_input($_POST["website"]);
      	 	 // check if URL address syntax is valid (this regular expression also allows dashes in the URL)
      	 	 if (!preg_match("/\b(?:(?:https?|ftp):\/\/|www\.)[-a-z0-9+&@#\/%?=~_|!:,.;]*[-a-z0-9+&@#\/%=~_|]/i",$website)) {
      	 	 	 $websiteErr = "Invalid URL";
      	 	 }
      	 }
      	 // Description
      	 if (empty($_POST["description"])) {
      	 	 $description = "";
      	 } else {
      	 	 $description = test_input($_POST["description"]);
      	 }
      	 // Gender
      	 if (empty($_POST["gender"])) {
      	 	 $genderErr = "Gender is required";
      	 } else {
      	 	 $gender = test_input($_POST["gender"]);
      	 }
      	 // Controllo se ci sono errori
      	 if ($userNameErr == "" && $passwordErr =="" && 
      	 	 $repeatedPasswordErr == "" && $nameErr == "" && $emailErr == "" && 
      	 	 $websiteErr == "" && $genderErr == "") {
      	 	// Tutti i dati sono stati inseriti correttamente
      	 	// Inserisco l'utente nel database
      	 	// Comunico che l'iscrizione è ok
	  	    doInsertUser();
	  	    return;
      	 }
      	 // C'è almeno un errore, quindi bisogna mostrare di nuovo il form
      	 // Continua sotto
     }
     // E' la prima volta che l'utente deve inserire i dati oppure c'è stato un
     // errore nella submit precedente
     // Mostro il form con gli eventuali messaggi di errore
     require('page_left.php'); 
	 echo '<div class="content">';
	 echo '<h2>Please, insert your data</h2>';
	 echo '<p><span class="errormsg">* required field.</span></p>';
	 // Dal form richiamo la stessa funzione
	 echo '<form method="post" action="index.php?action=2">';  
	 // userName
	 echo 'Username: <input type="text" name="userName" value="' . 
	 		$userName . '">';
	 echo '<span class="errormsg">* ';
	 if ($userNameErr != "") {
	 	 echo $userNameErr . '</span>';
	 } else {
	 	 echo '</span>';
	 }
	 echo '<br /><br />';
	 // password
	 echo 'Password: <input type="password" name="password" value="' . 
	 		$password . '">';
	 echo '<span class="errormsg">* ';
	 if ($passwordErr != "") {
	 	 echo $passwordErr . '</span>';
	 } else {
	 	 echo '</span>';
	 }
	 // Ripetizione della password
	 echo '<br /><br />';
	 echo 'Repeat Password: <input type="password" name="repeatedPassword" ' .
	 		'value="' . $repeatedPassword . '">';
	 echo '<span class="errormsg">* ';
	 if ($repeatedPasswordErr != "") {
	 	 echo $repeatedPasswordErr . '</span>';
	 } else {
	 	 echo '</span>';
	 }
	 // Nome
	 echo '<br /><br />';
	 echo 'Name: <input type="text" name="name" value="' . $name . '">';
	 echo '<span class="errormsg">* ';
	 if ($nameErr != "") {
	 	 echo $nameErr . '</span>';
	 } else {
	 	 echo '</span>';
	 }
	 // Email
	 echo '<br /><br />';
	 echo 'E-mail: <input type="text" name="email" value="' . $email . '">';
	 echo '<span class="errormsg">* ';
	 if ($emailErr != "") {
	 	 echo $emailErr . '</span>';
	 } else {
	 	 echo '</span>';
	 }
	 echo '<br /><br />';
	 // Website
	 echo 'Website: <input type="text" name="website" value="' . 
	 		$website . '">';
	 echo '<span class="errormsg">';
	 if ($websiteErr != "") {
	 	 echo $websiteErr . '</span>';
	 } else {
	 	 echo '</span>';
	 }
	 echo '<br /><br />';
	 // Descrizione
	 echo 'Description: <textarea name="description" rows="5" cols="40">' . 
	 		$description . '</textarea>';
	 echo '<br /><br />';
	 // Gender
	 echo 'Gender: <input type="radio" name="gender" ';
	 if ($gender=="female") 
	 	 echo ' checked '; 
	 echo 'value="female">Female ';
	 echo '<input type="radio" name="gender" ';
	 if ($gender=="male") 
	 	 echo ' checked '; 
	 echo 'value="male">Male ';
	 echo '<span class="errormsg">* ';
	 if ($genderErr != "") {
	 	 echo $genderErr . '</span>';
	 } else {
	 	 echo '</span>';
	 }
	 echo '<br /><br />';
	 // Submit
	 echo '<input type="submit" name="submit" value="Submit">';  
	 echo '</form>';
	 echo "</div>";
}

function doProfilePage() {
	  require('page_left.php'); 
	  echo "<div class=\"content\">";
	  echo "<p>TODO!</p>";
	  echo "</div>";
}

function doProfile() {
	  require('page_left.php'); 
	  echo "<div class=\"content\">";
	  echo "<p>TODO!</p>";
	  echo "</div>";
}

function doLogout() {
	  // Controllo se qualcuno è loggato
	  if (!isset($_SESSION['userName'])) {
	  	  doError("No one is logged in!");
	  } else {
	  	  // Distruggo la sessione
	  	  $name = $_SESSION['name'];
	  	  session_unset();
	  	  session_destroy();
	  	  require('page_left.php');
	  	  echo "<div class=\"content\">";
	  	  echo "<p>Bye bye $name</p>";
	  	  echo "</div>";
	  }
}

?>