package esempi;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

@WebServlet("/logout")
public class Logout extends HttpServlet {
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// Indica al browser di non mettere la pagina in cache
		response.setHeader("Cache-Control", "no-store, no-cache");
		response.setHeader("Pragma", "no-cache");
        response.setDateHeader( "Expires", 0 );
        
		// Recupera la sessione corrente e (se esiste) la cancella
		HttpSession session = request.getSession(false);
		if (session != null)
			session.invalidate();
		
		// Ridireziona alla pagina di login
		response.sendRedirect("./LoginPage.html");
	}

	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		doGet(request, response);
	}

}
