package esempi;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

@WebServlet("/pagina2")
public class Pagina2 extends HttpServlet {
	       
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		response.setContentType("text/html");
		
		// Indica al browser di non mettere la pagina in cache
		response.setHeader("Cache-Control", "no-store, no-cache");
		response.setHeader("Pragma", "no-cache");
        response.setDateHeader( "Expires", 0);
		
		PrintWriter out = response.getWriter();
		
		// Stampa l'intestazione
		out.println("<html><head><title>Pagina 2</title>" +
				    "</head><body>");
		
		String name = null; // Nome dell'utente "loggato"
		
		boolean error = false; // Flag che segnala errori
		String errorMessage = "Accesso negato: per accedere alla pagina &egrave; necessario effettuare il login"; // Messaggio di errore
		
		// Recupera la sessione corrente 
		HttpSession session = request.getSession(false);
		
		if (session==null){
			// Sessione non esistente: l'utente non ha effettuato il login
			error=true;	
		} else {
			name = (String) session.getAttribute("name");
			if (name == null){
				// La sessione esiste ma non contiene l'informazione cercata: 
				// l'utente non ha effettuato il login
				error=true;
			}
		}
			
		if (!error) {
			// Stampa la pagina di login con successo 
			out.println("<h3>Utente: "+name+"</h3>");
			out.println("<br><br><h2>Pagina 2</h2><br><br>" +
					    "<a href=\"login\">Vai alla pagina 1</a>" +
					    "<br><br>" +
					    "<a href=\"logout\">Log out</a>");
			
		} else {
			// Stampa la pagina di errore
			out.println("<h1>"+errorMessage+"</h1>" +
				        "<br><br>" +
				        "<a href=\"./LoginPage.html\">Vai alla pagina di login");
		}
		
		// Stampa la fine della pagina
		out.println("</body></html>");
	}

	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		doGet(request, response);
	}

}
