package esempi;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
 
/**
 * Servlet implementation class Login
 */
@WebServlet("/login")
public class Login extends HttpServlet {
	private Map<String, String> userPwdMap;
	private Map<String, String> userNameMap;
	
	
	
	@Override
	public void init() throws ServletException {
		userPwdMap = new HashMap<String, String>();
		userNameMap = new HashMap<String, String>();
		
		// Inizializza la map delle associazioni utente-password
        userPwdMap.put("tiezzi", "francesco");
        userPwdMap.put("gattuso", "gennaro");
        userPwdMap.put("nesta", "alessandro");
        userPwdMap.put("ambrosini", "massimo");
        
        // Inizializza la map delle associazioni utente-nome completo
        userNameMap.put("tiezzi", "Tiezzi Francesco");
        userNameMap.put("gattuso", "Gattuso Gennaro");
        userNameMap.put("nesta", "Nesta Alessandro");
        userNameMap.put("ambrosini", "Ambrosini Massimo");
        
        // Stampa su console le map
        System.out.println(userPwdMap);
        System.out.println(userNameMap);
	}
	
	
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		response.setContentType("text/html");
		
		PrintWriter out = response.getWriter();
		
		// Indica al browser di non mettere la pagina in cache
		response.setHeader("Cache-Control", "no-store, no-cache");
		response.setHeader("Pragma", "no-cache");
        response.setDateHeader( "Expires", 0 );
		
		// Stampa l'intestazione
		out.println("<html><head><title>Login page</title>" +
				    "</head><body>");
		
		String name = ""; // Nome dell'utente che ha effettuato il login con successo
		
		boolean error = false; // Flag che segnala errori nella fase di login
		String errorMessage = "Si &egrave; verificato un errore interno al sistema; " +
	                          "si prega di riprovare pi&ugrave; tardi."; // Messaggio di errore
		
		// Recupera la sessione corrente (se non esiste ne crea una nuova)
		HttpSession session = request.getSession();
		session.setMaxInactiveInterval(60*60*24*7);
		
		System.out.println("ID: "+session.getId() +" Interval: "+session.getMaxInactiveInterval());
		
		name = (String) session.getAttribute("name");
		
		// Controlla se la sessione e' nuova  
		if (name==null){
			// Nuova sessione: controlla se i dati di login nella form sono corretti 
			
			// Recupera dati dalla form
			String username = replaceAndFilter(request.getParameter("username"),"");
			String password = replaceAndFilter(request.getParameter("password"),"");
			
			
			// Recupera la password e il nome delle map
			String pwd = userPwdMap.get(username.trim());
			name = userNameMap.get(username.trim());
			if ((pwd != null) && (name != null)) {
				// Username esistente: controlla la password
				if (pwd.equals(password)) {
					// Password corretta: inserisce il nome dell'utente nella nuova sessionea
					session.setAttribute("name",name);					
				} else {
					// Password errato
					error = true;
					errorMessage="Password errata";
				}
			} else {
					// Username errato
					error = true;
					errorMessage="Username non esistente";
			}
			
         	//////// SESSIONE PERSISTENTE ////////
			Cookie sessionCookie = new Cookie("JSESSIONID",session.getId());
			sessionCookie.setMaxAge(60*60*24*7);
			response.addCookie(sessionCookie);
			//////////////////////////////////////
		} 
		
		
		if (!error) {
			// Stampa la pagina di login con successo 
			out.println("<h3>Utente: "+name+"</h3>");
			out.println("<br><br><h2>Pagina 1</h2><br><br>" +
					    "<a href=\"pagina2\">Vai alla pagina 2</a>" +
					    "<br><br>" +
					    "<a href=\"logout\">Log out</a>");
			
		} else {
			// Stampa la pagina di errore
			out.println("<h1>"+errorMessage+"</h1>" +
				        "<br><br>" +
				        "<a href=\"./LoginPage.html\">Torna alla pagina di login");
		}
		
		// Stampa la fine della pagina
		out.println("</body></html>");
	}

	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		doGet(request,response);
	}

	
	// Metodi di servizio
	private String replaceAndFilter(String orig, String repl){
		if ((orig == null) || (orig.trim().equals(""))) {
			return(repl);
			} else {
				// Filtra la stringa
				return(filter(orig));
			}
	}
	
	private String filter(String input){
		if (!hasSpecialChars(input)) {
			return(input);
		}
		StringBuffer filtered =
			new StringBuffer(input.length());
		char c;
		for(int i=0; i<input.length(); i++) {
			c = input.charAt(i);
			switch(c) {
			case '<': filtered.append("&lt;"); break;
			case '>': filtered.append("&gt;"); break;
			case '"': filtered.append("&quot;"); break;
			case '&': filtered.append("&amp;"); break;
			default: filtered.append(c);
			}
		}
		return(filtered.toString());
	}
	
	private boolean hasSpecialChars(String input){
		boolean flag = false;
		if ((input != null) && (input.length() > 0)) {
			char c;
			for(int i=0; i<input.length(); i++) {
				c = input.charAt(i);
				switch(c) {
				case '<': flag = true; break;
				case '>': flag = true; break;
				case '"': flag = true; break;
				case '&': flag = true; break;
				}
			}
		}
		return(flag);
	}
}
