<!DOCTYPE html>
<html>
<body>
<?php
    echo "<h3> Global variables are not visible inside a function</h3>";
	$x = 5; // global scope

	function myTest() {
		// using x inside this function will generate an error
    	echo "<p>Variable x inside function (error) is: $x</p>";
    } 
    myTest();
    echo "<p>Variable x outside function is: $x</p>";
    
    echo "<h3>Local variables are not visible outside the function in which they are declared</h3>";
    
    function myTest1() {
    	$y = 5; // local scope
    	$x = 7; // This is not the global variable x, because it is not visible
    	echo "<p>Variable y inside function is: $y</p>";
    	echo "<p>Variable x inside function is: $x</p>";
    } 
    myTest1();
    // using y outside the function will generate an error
    echo "<p>Variable y outside function (error) is: $y</p>";
    echo "<p>Variable x outside function kept its global value: $x</p>";
    
    echo "<h3>Global variables can be referred or declared inside a function with the specificator <code>global</code></h3>";
    $z = 10; // global
    function myTest2() {
    	global $z; // Refers to global $z
    	global $w; // Defines global $w
    	$w = 5;
    	$z = $z + $w;
    }

    myTest2();
    echo "<p>The value of the global variable w is $w </p>"; 
    echo "<p>The value of the global variable z is $z </p>";
    
    echo "<h3>Global variables can be accessed inside a function with the globar array  <code>\$GLOBALS</code></h3>";
    function myTest3() {
    	$GLOBALS['w'] += 7;
    	echo "<p>The value of the global variable w is " . $GLOBALS['w'] . "</p>"; 
    	echo "<p>The value of the global variable z is " . $GLOBALS['z'] . "</p>";
    }
    myTest3();
    
    echo "<h3>Local variables are not visible in functions that are called in their scope</h3>";
    function myTest4(){
    	$a = "I am local variable a inside function myTest4()";
    	echo "<p>$a</p>";
    	myTest5();
    }
    function myTest5(){
    	echo "<p>Local varibale a does not exists in myTest5(), which is called by myTest4()</p>";
    	echo $a;
    }
    myTest4();
    
    echo "<h3>Static local varibles keep their value across different calls of the same function</h3>";
    function myTest6() {
    	static $b = 0;
    	echo "<p>The static local variable b has value: $b</p>";
    	$b++;
    }

    myTest6();
    myTest6();
    myTest6();
    
    echo "<hr />";
    
    echo "<h3>Parameter passing is by value</h3>";
    $c = 3;
    $d = 4;
    function somma($x,$y){
    	return $x + $y;
    }
    function somma1($x,$y){
    	$x += $y; // Inside the function the parameters are just local variables
    	echo "<p>Inside function somma1 x is $x and y is $y</p>";
    }
    echo "<p>Sum of $c and $d is " . somma($c,$d) . "</p>";
    somma1($c,$d);
    echo "<p>Outside function somma1 the value of c is $c and the value of d is $d</p>";
    
    echo "<p>Consider also an associative arrray</p>";
    $age = array("Peter"=>35, "Ben"=>37, "Joe"=>43);
    echo "<p>age Array: <br />";
    foreach($age as $x => $x_value) {
    	echo "Key=" . $x . ", Value=" . $x_value;
    	echo "<br />";
    }
    echo "</p>";
    
    function birthday($a,$name) {
    	$a[$name] += 1; // The age of $name is updated
    	echo "<p> Updated (inside the function birthday) age of $name is " . $a[$name] .  "</p>";
    }
    
    birthday($age,"Peter"); // calling the function on Peter
    
   echo "<p>age Array after updating Peter age: <br />";
    foreach($age as $x => $x_value) {
    	echo "Key=" . $x . ", Value=" . $x_value;
    	echo "<br />";
    }
     echo "</p>";
     
    echo "<h3>However! If a reference of an object is passed by value, then the object can be modified by actions inside the function!</h3>";
    
    class Car {
    	function Car() {
    		$this->model = "VW";
    	}
    }
    $herbie = new Car();
    echo "<p>Herbie's model is " . $herbie->model . "</p>";
    
    function updateModel($car,$newModel){
    	$car->model = $newModel;
    }
    
    updateModel($herbie,"Pippo"); // Calling function passing reference of herbie!
    
    echo "<p>Herbie's model after update is " . $herbie->model . "</p>";
?> 
</body>
</html>