#include "list.h"
#include <stdlib.h>

List* empty() {
  return NULL;
}

int size( List* list ) {
  int counter = 0;
  while (list != NULL) {
    list = list->next;
    counter++;
  }
  return counter;
}

int isEmpty( List* list ) {
  return list == NULL;
}

List* createListElement( int v, List *next ) {
  List* newList = malloc(sizeof(List));
  newList->value = v;
  newList->next = next;
  return newList;
}

List* add( List* list , int v ) {
  return createListElement( v , list );
}

int contains( List* list , int v ) {
  int result = 0;
  while ((!result)&&(list != NULL)) {
    result = (list->value==v);
    list = list->next;
  }
  return result;
}

List* remove( List* list , int v ) {
  if (list == NULL) {
    return list;
  }
  if (list->value == v) {
    List* result = list->next;
    free(list);
    return result;
  }
  list->next = remove(list->next,v);
  return list;
}

List* addInOrder( List* list , int v ) {
  if ((list == NULL)||(list->value>v)) {
    return createListElement(v,NULL);
  } else {
    list->next = addInOrder(list->next,v);
    return list;
  }
}

List* sort( List* list ) {
  List* result = NULL;
  while (list != NULL) {
    result = addInOrder( result , list->value );
    list = list->next;
  }
  return result;
}

int* toArray( List* list ) {
  int s = size( list );
  if (s == 0) return NULL;
  int *result = malloc(s*sizeof(int));
  int counter = 0;
  while (list != NULL) {
    result[counter] = list->value;
    list = list->next;
  }
  return result;
}
