//
// Created by Michele Loreti on 2019-05-22.
//

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "ceasar.h"

char encodechar( char c, int k ) {
    if ((c<'A')||(c>'z')) {
        return c;
    }
    char base = 'A';
    if (c>='a') {
        base = 'a';
    }
    return base+((c-base+k)%26);
}

char* encodestring( const char* str , int n , int k ) {
    char* out = malloc(sizeof(char)*n);
    for( int i=0 ; i<n ; i++ ) {
        out[i] = encodechar(str[i],k);
    }
    return out;
}

void encodefile( const char* in, const char* out, int k) {
    FILE* fin = fopen( in , "r" );
    FILE* fout = fopen( out , "w" );
    char buffer[256];
    while ( fgets(buffer,256,fin)  != NULL ) {
        fputs(encodestring(buffer,strlen(buffer),k),fout);
    }
    fflush(fout);
    fclose(fin);
    fclose(fout);
}

char decodechar( char c, int k ) {
    if ((c<'A')||(c>'z')) {
        return c;
    }
    char base = 'A';
    if (c>='a') {
        base = 'a';
    }
    int shift = (c-base-k)%26;
    if (shift < 0) {
        return (c>='a'?'z'+shift+1:'a'+shift);
    } else {
        return base+shift;
    }
}

char* decodestring( char* str , int n , int k ) {
    char* out = malloc(sizeof(char)*n);
    for( int i=0 ; i<n ; i++ ) {
        out[i] = decodechar(str[i],k);
    }
    return out;
}

void decodefile( char* in, char* out, int k) {
    FILE* fin = fopen( in , "r" );
    FILE* fout = fopen( out , "w" );
    char buffer[256];
    while ( fgets(buffer,256,fin)  != NULL ) {
        fputs(decodestring(buffer,strlen(buffer),k),fout);
    }
    fclose(fin);
    fclose(fout);
}