#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

void echo( const int fd , const char* file ) {
  char* buffer = malloc(sizeof(char)*100);
  ssize_t s = 1;
  printf("READING: %s\n",file);
  printf("=============================\n");
  while ( (s=read( fd , buffer , 100)) > 0 ) {
    char *str = malloc(sizeof(char)*s);
    strncpy(str,buffer,s);
    printf("%s",str);
    free(str);
  }
  printf("\n================================\n");
  free(buffer);
}

int main( int argc , char *argv[] )
{
  if (argc != 2) {
    printf("ERROR: testread <filename>\n");
    return -1;
  }
  int fd = open( argv[1] , O_RDONLY );
  if (fd<0) {
    perror("Open");
  } else {
    echo( fd , argv[1] );
  }
}
