#include <stdio.h>
#include <signal.h>
#include <stdlib.h>
#include <unistd.h>


void sighup(int); /* routines child will call upon sigtrap */
void sigint(int);
void sigquit(int);

int main()
{
  int pid;

  /* get child process */

   if ((pid = fork()) < 0) {
        perror("fork");
        exit(1);
    }

   if (pid == 0)
     { /* child */
       printf("\nCHILD: Setting Signal Handlers!\n\n");
       signal(SIGHUP,sighup); /* set function calls */
       signal(SIGINT,sigint);
       signal(SIGQUIT, sigquit);
       printf("\nCHILD: DONE!\n\n");
       for(;;); /* loop for ever */
     }
  else /* parent */
     {  /* pid hold id of child */
       sleep(3); /* pause for 3 secs */
       printf("\nPARENT: sending SIGHUP\n\n");
       kill(pid,SIGHUP);
       sleep(3); /* pause for 3 secs */
       printf("\nPARENT: sending SIGINT\n\n");
       kill(pid,SIGINT);
       sleep(3); /* pause for 3 secs */
       printf("\nPARENT: sending SIGQUIT\n\n");
       kill(pid,SIGQUIT);
       sleep(3);
     }
}

void sighup(int i)
{  signal(SIGHUP,sighup); /* reset signal */
   printf("CHILD: I have received a SIGHUP\n");
}

void sigint(int i)
{  signal(SIGINT,sigint); /* reset signal */
   printf("CHILD: I have received a SIGINT\n");
}

void sigquit(int i)
{ printf("My DADDY has Killed me!!!\n");
  exit(0);
}
